<?php
// Veritabanı bağlantı ayarları
define('DB_HOST', 'localhost');
define('DB_NAME', 'dnphrrbjkj_sanstib');
define('DB_USER', 'dnphrrbjkj_admin');
define('DB_PASS', '154854654Admin.!');

// Telegram Bot ayarları (Fallback - veritabanından okunamazsa kullanılır)
define('TELEGRAM_BOT_TOKEN', 'YOUR_BOT_TOKEN_HERE'); // Telegram bot token'ınızı buraya ekleyin
define('TELEGRAM_CHAT_ID', 'YOUR_CHAT_ID_HERE'); // Telegram kanal/chat ID'nizi buraya ekleyin

// t.ly API anahtarı (Fallback)
define('TLY_API_KEY', 'YOUR_TLY_API_KEY_HERE'); // t.ly API anahtarınızı buraya ekleyin

/**
 * Bot token'ını veritabanından alır, yoksa config'den alır
 * @param PDO|null $pdo Veritabanı bağlantısı (opsiyonel)
 * @return string Bot token
 */
function getBotToken($pdo = null) {
    // Önce veritabanından dene
    if ($pdo) {
        try {
            $stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'bot_token'");
            $result = $stmt->fetch();
            if ($result && !empty($result['setting_value'])) {
                return $result['setting_value'];
            }
        } catch (Exception $e) {
            error_log("Bot token okuma hatası: " . $e->getMessage());
        }
    }
    
    // Veritabanından alınamazsa config'den al
    $token = defined('TELEGRAM_BOT_TOKEN') ? TELEGRAM_BOT_TOKEN : '';
    return ($token !== 'YOUR_BOT_TOKEN_HERE' && !empty($token)) ? $token : '';
}

/**
 * t.ly API anahtarını veritabanından alır, yoksa config'den alır
 * @param PDO|null $pdo Veritabanı bağlantısı (opsiyonel)
 * @return string t.ly API anahtarı
 */
function getTlyApiKey($pdo = null) {
    // Önce veritabanından dene
    if ($pdo) {
        try {
            $stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'tly_api_key'");
            $result = $stmt->fetch();
            if ($result && !empty($result['setting_value'])) {
                return $result['setting_value'];
            }
        } catch (Exception $e) {
            error_log("t.ly API anahtarı okuma hatası: " . $e->getMessage());
        }
    }
    
    // Veritabanından alınamazsa config'den al
    $apiKey = defined('TLY_API_KEY') ? TLY_API_KEY : '';
    return ($apiKey !== 'YOUR_TLY_API_KEY_HERE' && !empty($apiKey)) ? $apiKey : '';
}

// Veritabanı bağlantısı
function getDBConnection() {
    try {
        $pdo = new PDO(
            "mysql:host=" . DB_HOST . ";dbname=" . DB_NAME . ";charset=utf8mb4",
            DB_USER,
            DB_PASS,
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
                PDO::ATTR_EMULATE_PREPARES => false
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        die("Veritabanı bağlantı hatası: " . $e->getMessage());
    }
}

