<?php
/**
 * Admin Panel - Tek Sayfa
 * Domain ve kanal yönetimi
 */

session_start();
require_once 'config.php';
require_once 'telegram_bot.php';

// Şifre kontrolü
$pdo = getDBConnection();
$stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'admin_password'");
$adminPassword = $stmt->fetch()['setting_value'] ?? 'admin123';

// Giriş kontrolü
if (!isset($_SESSION['admin_logged_in'])) {
    if (isset($_POST['password'])) {
        if ($_POST['password'] === $adminPassword) {
            $_SESSION['admin_logged_in'] = true;
        } else {
            $error = "Yanlış şifre!";
        }
    }
    
    if (!isset($_SESSION['admin_logged_in'])) {
        ?>
        <!DOCTYPE html>
        <html lang="tr">
        <head>
            <meta charset="UTF-8">
            <meta name="viewport" content="width=device-width, initial-scale=1.0">
            <title>Admin Girişi</title>
            <style>
                * { margin: 0; padding: 0; box-sizing: border-box; }
                body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; display: flex; align-items: center; justify-content: center; }
                .login-box { background: white; padding: 40px; border-radius: 10px; box-shadow: 0 10px 40px rgba(0,0,0,0.2); max-width: 400px; width: 100%; }
                h1 { margin-bottom: 30px; color: #333; text-align: center; }
                input[type="password"] { width: 100%; padding: 12px; border: 2px solid #ddd; border-radius: 5px; font-size: 16px; margin-bottom: 20px; }
                button { width: 100%; padding: 12px; background: #667eea; color: white; border: none; border-radius: 5px; font-size: 16px; cursor: pointer; }
                button:hover { background: #5568d3; }
                .error { color: red; margin-bottom: 15px; text-align: center; }
            </style>
        </head>
        <body>
            <div class="login-box">
                <h1>🔐 Admin Girişi</h1>
                <?php if (isset($error)): ?><div class="error"><?= htmlspecialchars($error) ?></div><?php endif; ?>
                <form method="POST">
                    <input type="password" name="password" placeholder="Şifre" required autofocus>
                    <button type="submit">Giriş Yap</button>
                </form>
            </div>
        </body>
        </html>
        <?php
        exit;
    }
}

// Çıkış
if (isset($_GET['logout'])) {
    session_destroy();
    header('Location: admin.php');
    exit;
}

// AJAX istekleri
if ($_SERVER['REQUEST_METHOD'] === 'POST' && isset($_POST['action'])) {
    header('Content-Type: application/json');
    
    switch ($_POST['action']) {
        case 'set_active_channel':
            $channelId = $_POST['channel_id'] ?? null;
            if ($channelId) {
                $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'active_channel_id'");
                $stmt->execute([$channelId]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Kanal ID gerekli']);
            }
            exit;
            
        case 'add_domain':
            $domainUrl = $_POST['domain_url'] ?? '';
            if ($domainUrl) {
                try {
                    $stmt = $pdo->prepare("INSERT INTO domains (domain_url) VALUES (?)");
                    $stmt->execute([$domainUrl]);
                    echo json_encode(['success' => true]);
                } catch (PDOException $e) {
                    echo json_encode(['success' => false, 'error' => 'Domain zaten kayıtlı']);
                }
            } else {
                echo json_encode(['success' => false, 'error' => 'Domain URL gerekli']);
            }
            exit;
            
        case 'delete_domain':
            $domainId = $_POST['domain_id'] ?? null;
            if ($domainId) {
                $stmt = $pdo->prepare("DELETE FROM domains WHERE id = ?");
                $stmt->execute([$domainId]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Domain ID gerekli']);
            }
            exit;
            
        case 'update_redirect_domain':
            $domainId = $_POST['domain_id'] ?? null;
            $redirectDomain = $_POST['redirect_domain'] ?? '';
            if ($domainId && $redirectDomain) {
                // URL formatını kontrol et
                if (!filter_var($redirectDomain, FILTER_VALIDATE_URL)) {
                    echo json_encode(['success' => false, 'error' => 'Geçersiz URL formatı']);
                    exit;
                }
                
                $stmt = $pdo->prepare("UPDATE domains SET redirect_domain = ?, last_check = NOW() WHERE id = ?");
                $stmt->execute([$redirectDomain, $domainId]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Domain ID ve redirect domain gerekli']);
            }
            exit;
            
        case 'change_password':
            $newPassword = $_POST['new_password'] ?? '';
            if ($newPassword) {
                $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'admin_password'");
                $stmt->execute([$newPassword]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Yeni şifre gerekli']);
            }
            exit;
            
        case 'update_bot_token':
            $botToken = $_POST['bot_token'] ?? '';
            if ($botToken) {
                // Token formatını kontrol et (basit kontrol)
                if (strlen($botToken) < 20) {
                    echo json_encode(['success' => false, 'error' => 'Geçersiz bot token formatı']);
                    exit;
                }
                
                $stmt = $pdo->prepare("UPDATE settings SET setting_value = ? WHERE setting_key = 'bot_token'");
                $stmt->execute([$botToken]);
                echo json_encode(['success' => true]);
            } else {
                echo json_encode(['success' => false, 'error' => 'Bot token gerekli']);
            }
            exit;
            
        case 'send_test_message':
            $channelId = $_POST['channel_id'] ?? null;
            if (!$channelId) {
                echo json_encode(['success' => false, 'error' => 'Kanal ID gerekli']);
                exit;
            }
            
            // Test mesajı için varsayılan bir domain kullan (veya mesaj.md'den parse et)
            // Örnek domain kullanarak mesajı oluştur
            $testDomain = 'https://example.com/tr'; // Test için örnek domain
            
            $messageData = parseMessageTemplate($testDomain);
            
            // Seçilen kanala mesaj gönder
            $result = sendTelegramMessageToChannel($channelId, $messageData['message'], $messageData['keyboard'], $pdo);
            
            if ($result['success']) {
                echo json_encode(['success' => true, 'message' => 'Test mesajı başarıyla gönderildi!']);
            } else {
                echo json_encode(['success' => false, 'error' => $result['error'] ?? 'Mesaj gönderilemedi']);
            }
            exit;
    }
}


// Verileri al
$channels = $pdo->query("SELECT * FROM channels ORDER BY last_activity DESC")->fetchAll();
$domains = $pdo->query("SELECT * FROM domains ORDER BY id DESC")->fetchAll();
$activeChannelId = getActiveChannelId($pdo);

// Bot token'ı al
$stmt = $pdo->query("SELECT setting_value FROM settings WHERE setting_key = 'bot_token'");
$currentBotToken = $stmt->fetch()['setting_value'] ?? '';

// Domain history ve failed messages için domain ID'ye göre sorgu hazırla
$domainHistory = [];
$failedMessages = [];
if (!empty($domains)) {
    $domainIds = array_column($domains, 'id');
    $placeholders = implode(',', array_fill(0, count($domainIds), '?'));
    
    // Domain history
    $stmt = $pdo->prepare("
        SELECT dh.*, d.domain_url as domain_url_full
        FROM domain_history dh
        JOIN domains d ON dh.domain_id = d.id
        WHERE dh.domain_id IN ($placeholders)
        ORDER BY dh.created_at DESC
        LIMIT 50
    ");
    $stmt->execute($domainIds);
    $domainHistory = $stmt->fetchAll();
    
    // Failed messages
    $stmt = $pdo->prepare("
        SELECT fm.*, d.domain_url as domain_url_full
        FROM failed_messages fm
        JOIN domains d ON fm.domain_id = d.id
        WHERE fm.domain_id IN ($placeholders)
        ORDER BY fm.created_at DESC
        LIMIT 20
    ");
    $stmt->execute($domainIds);
    $failedMessages = $stmt->fetchAll();
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Admin Panel - Domain Takip Sistemi</title>
    <style>
        * { margin: 0; padding: 0; box-sizing: border-box; }
        body { font-family: -apple-system, BlinkMacSystemFont, 'Segoe UI', Roboto, sans-serif; background: #f5f5f5; padding: 20px; }
        .container { max-width: 1200px; margin: 0 auto; }
        header { background: white; padding: 20px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); display: flex; justify-content: space-between; align-items: center; }
        h1 { color: #333; }
        .logout-btn { background: #dc3545; color: white; padding: 10px 20px; border: none; border-radius: 5px; text-decoration: none; }
        .logout-btn:hover { background: #c82333; }
        .section { background: white; padding: 25px; border-radius: 10px; margin-bottom: 20px; box-shadow: 0 2px 10px rgba(0,0,0,0.1); }
        .section h2 { margin-bottom: 20px; color: #333; border-bottom: 2px solid #667eea; padding-bottom: 10px; }
        .form-group { margin-bottom: 15px; }
        label { display: block; margin-bottom: 5px; color: #555; font-weight: 500; }
        input[type="text"], input[type="password"], select { width: 100%; padding: 10px; border: 2px solid #ddd; border-radius: 5px; font-size: 14px; }
        input:focus, select:focus { outline: none; border-color: #667eea; }
        .btn { padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer; font-size: 14px; }
        .btn-primary { background: #667eea; color: white; }
        .btn-primary:hover { background: #5568d3; }
        .btn-danger { background: #dc3545; color: white; }
        .btn-danger:hover { background: #c82333; }
        .btn-success { background: #28a745; color: white; }
        .btn-success:hover { background: #218838; }
        table { width: 100%; border-collapse: collapse; margin-top: 15px; }
        th, td { padding: 12px; text-align: left; border-bottom: 1px solid #ddd; }
        th { background: #f8f9fa; font-weight: 600; color: #333; }
        tr:hover { background: #f8f9fa; }
        .badge { padding: 5px 10px; border-radius: 5px; font-size: 12px; font-weight: 600; }
        .badge-success { background: #d4edda; color: #155724; }
        .badge-secondary { background: #e2e3e5; color: #383d41; }
        .badge-info { background: #d1ecf1; color: #0c5460; }
        .badge-danger { background: #f8d7da; color: #721c24; }
        .btn-secondary { background: #6c757d; color: white; }
        .btn-secondary:hover { background: #5a6268; }
        .inline-edit { display: inline-flex; gap: 5px; align-items: center; }
        .inline-edit input { padding: 5px; border: 1px solid #ddd; border-radius: 3px; font-size: 12px; }
        .alert { padding: 15px; border-radius: 5px; margin-bottom: 20px; }
        .alert-success { background: #d4edda; color: #155724; border: 1px solid #c3e6cb; }
        .alert-info { background: #d1ecf1; color: #0c5460; border: 1px solid #bee5eb; }
        .empty-state { text-align: center; padding: 40px; color: #999; }
        .grid { display: grid; grid-template-columns: 1fr 1fr; gap: 20px; }
        @media (max-width: 768px) { .grid { grid-template-columns: 1fr; } }
        .btn-info { background: #17a2b8; color: white; }
        .btn-info:hover { background: #138496; }
        .modal { display: none; position: fixed; z-index: 1000; left: 0; top: 0; width: 100%; height: 100%; background: rgba(0,0,0,0.5); }
        .modal-content { background: white; margin: 10% auto; padding: 30px; border-radius: 10px; max-width: 500px; width: 90%; box-shadow: 0 5px 20px rgba(0,0,0,0.3); }
        .modal-header { display: flex; justify-content: space-between; align-items: center; margin-bottom: 20px; }
        .modal-header h3 { margin: 0; color: #333; }
        .close { font-size: 28px; font-weight: bold; color: #aaa; cursor: pointer; }
        .close:hover { color: #000; }
        .test-message-section { margin-top: 20px; padding-top: 20px; border-top: 2px solid #f0f0f0; }
    </style>
</head>
<body>
    <div class="container">
        <header>
            <h1>⚙️ Admin Panel</h1>
            <a href="?logout=1" class="logout-btn">Çıkış Yap</a>
        </header>
        
        <div id="alert-container"></div>
        
        <!-- Kanal Yönetimi -->
        <div class="section">
            <h2>📢 Kanal Yönetimi</h2>
            <div class="form-group">
                <label>Mesaj Gönderilecek Kanal:</label>
                <select id="active-channel-select">
                    <option value="">-- Kanal Seçin --</option>
                    <?php foreach ($channels as $channel): ?>
                        <option value="<?= $channel['chat_id'] ?>" <?= $channel['chat_id'] == $activeChannelId ? 'selected' : '' ?>>
                            <?= htmlspecialchars($channel['chat_title'] ?: 'İsimsiz') ?> 
                            (<?= htmlspecialchars($channel['chat_type']) ?>)
                            <?= $channel['chat_username'] ? ' - @' . htmlspecialchars($channel['chat_username']) : '' ?>
                            - ID: <?= $channel['chat_id'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <button class="btn btn-primary" onclick="setActiveChannel()">Aktif Kanalı Kaydet</button>
            
            <!-- Test Mesajı Bölümü -->
            <div class="test-message-section">
                <h3>📤 Test Mesajı Gönder</h3>
                <p style="color: #666; margin-bottom: 15px; font-size: 14px;">Hazırladığınız mesajı seçtiğiniz kanala/grupa test olarak gönderin.</p>
                <button class="btn btn-info" onclick="openTestMessageModal()">Test Mesajı Gönder</button>
            </div>
            
            <div style="margin-top: 30px;">
                <h3>Kayıtlı Kanallar ve Gruplar</h3>
                <?php if (empty($channels)): ?>
                    <div class="empty-state">
                        <p>Henüz kayıtlı kanal/grup yok.</p>
                        <p style="margin-top: 10px; font-size: 14px;">Botu bir kanala veya gruba ekleyin, webhook aktif olduğunda otomatik kaydedilecektir.</p>
                    </div>
                <?php else: ?>
                    <table>
                        <thead>
                            <tr>
                                <th>Kanal/Grup Adı</th>
                                <th>Tip</th>
                                <th>Username</th>
                                <th>Chat ID</th>
                                <th>Son Aktivite</th>
                                <th>Durum</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($channels as $channel): ?>
                                <tr>
                                    <td><?= htmlspecialchars($channel['chat_title'] ?: 'İsimsiz') ?></td>
                                    <td><?= htmlspecialchars($channel['chat_type']) ?></td>
                                    <td><?= $channel['chat_username'] ? '@' . htmlspecialchars($channel['chat_username']) : '-' ?></td>
                                    <td><code><?= $channel['chat_id'] ?></code></td>
                                    <td><?= date('d.m.Y H:i', strtotime($channel['last_activity'])) ?></td>
                                    <td>
                                        <?php if ($channel['chat_id'] == $activeChannelId): ?>
                                            <span class="badge badge-success">Aktif</span>
                                        <?php else: ?>
                                            <span class="badge badge-secondary">Pasif</span>
                                        <?php endif; ?>
                                    </td>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                    </table>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Domain Yönetimi -->
        <div class="section">
            <h2>🌐 Domain Yönetimi</h2>
            <div class="form-group">
                <label>Yeni Domain Ekle:</label>
                <input type="text" id="new-domain" placeholder="https://t.ly/vidoadres" style="display: inline-block; width: calc(100% - 120px);">
                <button class="btn btn-success" onclick="addDomain()" style="width: 110px; margin-left: 10px;">Ekle</button>
            </div>
            
            <h3 style="margin-top: 30px;">Kontrol Edilen Domainler</h3>
            <?php if (empty($domains)): ?>
                <div class="empty-state">Henüz domain eklenmemiş.</div>
            <?php else: ?>
                <table>
                    <thead>
                        <tr>
                            <th>Domain URL</th>
                            <th>Yönlendirilen Domain</th>
                            <th>Son Kontrol</th>
                            <th>İşlem</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($domains as $domain): ?>
                            <tr>
                                <td><code><?= htmlspecialchars($domain['domain_url']) ?></code></td>
                                <td>
                                    <div style="display: flex; gap: 5px; align-items: center;">
                                        <span id="redirect-domain-<?= $domain['id'] ?>">
                                            <?= $domain['redirect_domain'] ? '<code>' . htmlspecialchars($domain['redirect_domain']) . '</code>' : '<em>Henüz kontrol edilmedi</em>' ?>
                                        </span>
                                        <button class="btn btn-primary" onclick="editRedirectDomain(<?= $domain['id'] ?>, '<?= htmlspecialchars($domain['redirect_domain'] ?? '') ?>')" style="padding: 5px 10px; font-size: 12px;">Düzenle</button>
                                    </div>
                                </td>
                                <td><?= $domain['last_check'] ? date('d.m.Y H:i', strtotime($domain['last_check'])) : '-' ?></td>
                                <td>
                                    <button class="btn btn-danger" onclick="deleteDomain(<?= $domain['id'] ?>)">Sil</button>
                                </td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            <?php endif; ?>
            
            <!-- Domain Geçmişi -->
            <?php if (!empty($domains)): ?>
                <div style="margin-top: 30px;">
                    <h3>📜 Domain Kontrol Geçmişi</h3>
                    <?php 
                    $domainHistoryFiltered = array_filter($domainHistory, function($h) use ($domains) {
                        return in_array($h['domain_id'], array_column($domains, 'id'));
                    });
                    ?>
                    <?php if (empty($domainHistoryFiltered)): ?>
                        <div class="empty-state">Henüz geçmiş kaydı yok.</div>
                    <?php else: ?>
                        <div style="max-height: 400px; overflow-y: auto; margin-top: 15px;">
                            <table>
                                <thead>
                                    <tr>
                                        <th>Domain</th>
                                        <th>Eski Domain</th>
                                        <th>Yeni Domain</th>
                                        <th>Durum</th>
                                        <th>Tarih</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach (array_slice($domainHistoryFiltered, 0, 20) as $history): ?>
                                        <tr>
                                            <td><code><?= htmlspecialchars($history['domain_url']) ?></code></td>
                                            <td><?= $history['old_redirect_domain'] ? '<code>' . htmlspecialchars($history['old_redirect_domain']) . '</code>' : '<em>-</em>' ?></td>
                                            <td><?= $history['new_redirect_domain'] ? '<code>' . htmlspecialchars($history['new_redirect_domain']) . '</code>' : '<em>-</em>' ?></td>
                                            <td>
                                                <?php if ($history['check_status'] === 'success'): ?>
                                                    <span class="badge badge-success">Başarılı</span>
                                                <?php else: ?>
                                                    <span class="badge badge-danger" style="background: #f8d7da; color: #721c24;">Hata</span>
                                                <?php endif; ?>
                                            </td>
                                            <td><?= date('d.m.Y H:i', strtotime($history['created_at'])) ?></td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            <?php endif; ?>
        </div>
        
        <!-- Başarısız Mesajlar -->
        <?php if (!empty($failedMessages)): ?>
            <div class="section">
                <h2>⚠️ Başarısız Mesajlar (Retry Bekliyor)</h2>
                <table>
                    <thead>
                        <tr>
                            <th>Domain</th>
                            <th>Yönlendirilen Domain</th>
                            <th>Kanal ID</th>
                            <th>Durum</th>
                            <th>Deneme</th>
                            <th>Hata</th>
                            <th>Tarih</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php foreach ($failedMessages as $failed): ?>
                            <tr>
                                <td><code><?= htmlspecialchars($failed['domain_url']) ?></code></td>
                                <td><code><?= htmlspecialchars($failed['redirect_domain']) ?></code></td>
                                <td><code><?= $failed['channel_id'] ?></code></td>
                                <td>
                                    <?php 
                                    $statusColors = [
                                        'pending' => 'badge-secondary',
                                        'retrying' => 'badge-info',
                                        'failed' => 'badge-danger',
                                        'sent' => 'badge-success'
                                    ];
                                    $color = $statusColors[$failed['status']] ?? 'badge-secondary';
                                    ?>
                                    <span class="badge <?= $color ?>"><?= ucfirst($failed['status']) ?></span>
                                </td>
                                <td><?= $failed['retry_count'] ?>/<?= $failed['max_retries'] ?></td>
                                <td style="max-width: 200px; overflow: hidden; text-overflow: ellipsis; white-space: nowrap;" title="<?= htmlspecialchars($failed['error_message'] ?? '') ?>">
                                    <?= htmlspecialchars(substr($failed['error_message'] ?? '-', 0, 50)) ?>
                                </td>
                                <td><?= date('d.m.Y H:i', strtotime($failed['created_at'])) ?></td>
                            </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        <?php endif; ?>
        
        <!-- Bot Ayarları -->
        <div class="section">
            <h2>🤖 Bot Ayarları</h2>
            <div class="form-group">
                <label>Telegram Bot Token:</label>
                <div style="display: flex; gap: 10px;">
                    <input type="text" id="bot-token" placeholder="Bot token girin" value="<?= htmlspecialchars($currentBotToken) ?>" style="flex: 1;">
                    <button class="btn btn-primary" onclick="updateBotToken()">Kaydet</button>
                </div>
                <small style="color: #666; display: block; margin-top: 5px;">
                    Bot token'ınızı @BotFather'dan alabilirsiniz. Token formatı: 123456789:ABCdefGHIjklMNOpqrsTUVwxyz
                </small>
                <?php if (empty($currentBotToken)): ?>
                    <div class="alert alert-info" style="margin-top: 15px;">
                        ⚠️ Bot token ayarlanmamış! Lütfen bot token'ınızı girin.
                    </div>
                <?php endif; ?>
            </div>
        </div>
        
        <!-- Ayarlar -->
        <div class="section">
            <h2>🔒 Güvenlik Ayarları</h2>
            <div class="form-group">
                <label>Admin Şifresini Değiştir:</label>
                <input type="password" id="new-password" placeholder="Yeni şifre">
                <button class="btn btn-primary" onclick="changePassword()" style="margin-top: 10px;">Şifreyi Değiştir</button>
            </div>
        </div>
    </div>
    
    <!-- Test Mesajı Modal -->
    <div id="testMessageModal" class="modal">
        <div class="modal-content">
            <div class="modal-header">
                <h3>📤 Test Mesajı Gönder</h3>
                <span class="close" onclick="closeTestMessageModal()">&times;</span>
            </div>
            <div class="form-group">
                <label>Kanal/Grup Seçin:</label>
                <select id="test-channel-select">
                    <option value="">-- Kanal/Grup Seçin --</option>
                    <?php foreach ($channels as $channel): ?>
                        <option value="<?= $channel['chat_id'] ?>">
                            <?= htmlspecialchars($channel['chat_title'] ?: 'İsimsiz') ?> 
                            (<?= htmlspecialchars($channel['chat_type']) ?>)
                            <?= $channel['chat_username'] ? ' - @' . htmlspecialchars($channel['chat_username']) : '' ?>
                            - ID: <?= $channel['chat_id'] ?>
                        </option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div style="margin-top: 20px;">
                <button class="btn btn-success" onclick="sendTestMessage()" style="width: 100%;">Test Mesajı Gönder</button>
                <button class="btn btn-secondary" onclick="closeTestMessageModal()" style="width: 100%; margin-top: 10px;">İptal</button>
            </div>
        </div>
    </div>
    
    <script>
        function showAlert(message, type = 'success') {
            const alertContainer = document.getElementById('alert-container');
            const alert = document.createElement('div');
            alert.className = `alert alert-${type}`;
            alert.textContent = message;
            alertContainer.appendChild(alert);
            setTimeout(() => alert.remove(), 5000);
        }
        
        function setActiveChannel() {
            const channelId = document.getElementById('active-channel-select').value;
            if (!channelId) {
                showAlert('Lütfen bir kanal seçin!', 'info');
                return;
            }
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=set_active_channel&channel_id=${channelId}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Aktif kanal başarıyla güncellendi!');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function addDomain() {
            const domainUrl = document.getElementById('new-domain').value.trim();
            if (!domainUrl) {
                showAlert('Lütfen bir domain URL girin!', 'info');
                return;
            }
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=add_domain&domain_url=${encodeURIComponent(domainUrl)}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Domain başarıyla eklendi!');
                    document.getElementById('new-domain').value = '';
                    setTimeout(() => location.reload(), 1000);
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function deleteDomain(domainId) {
            if (!confirm('Bu domaini silmek istediğinize emin misiniz?')) return;
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=delete_domain&domain_id=${domainId}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Domain başarıyla silindi!');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function editRedirectDomain(domainId, currentDomain) {
            const container = document.getElementById(`redirect-domain-${domainId}`);
            // Mevcut HTML'i sakla (geri dönüş için)
            container.setAttribute('data-original', container.innerHTML);
            
            // Input alanı oluştur
            const escapedDomain = (currentDomain || '').replace(/"/g, '&quot;').replace(/'/g, '&#39;');
            container.innerHTML = `
                <input type="text" id="redirect-input-${domainId}" value="${escapedDomain}" placeholder="https://example.com/tr" style="width: 300px; padding: 5px;">
                <button class="btn btn-success" onclick="saveRedirectDomain(${domainId})" style="padding: 5px 10px; font-size: 12px;">Kaydet</button>
                <button class="btn btn-secondary" onclick="cancelEditRedirectDomain(${domainId})" style="padding: 5px 10px; font-size: 12px;">İptal</button>
            `;
        }
        
        function cancelEditRedirectDomain(domainId) {
            const container = document.getElementById(`redirect-domain-${domainId}`);
            const originalHtml = container.getAttribute('data-original');
            if (originalHtml) {
                container.innerHTML = originalHtml;
            }
        }
        
        function saveRedirectDomain(domainId) {
            const input = document.getElementById(`redirect-input-${domainId}`);
            const redirectDomain = input.value.trim();
            
            if (!redirectDomain) {
                showAlert('Redirect domain boş olamaz!', 'info');
                return;
            }
            
            // URL formatını kontrol et
            if (!redirectDomain.match(/^https?:\/\/.+/)) {
                showAlert('Geçerli bir URL girin (http:// veya https:// ile başlamalı)', 'info');
                return;
            }
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=update_redirect_domain&domain_id=${domainId}&redirect_domain=${encodeURIComponent(redirectDomain)}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Redirect domain başarıyla güncellendi!');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function updateBotToken() {
            const botToken = document.getElementById('bot-token').value.trim();
            if (!botToken) {
                showAlert('Lütfen bot token girin!', 'info');
                return;
            }
            
            if (botToken.length < 20) {
                showAlert('Geçersiz bot token formatı!', 'info');
                return;
            }
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=update_bot_token&bot_token=${encodeURIComponent(botToken)}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Bot token başarıyla güncellendi!');
                    setTimeout(() => location.reload(), 1000);
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function changePassword() {
            const newPassword = document.getElementById('new-password').value.trim();
            if (!newPassword) {
                showAlert('Lütfen yeni şifre girin!', 'info');
                return;
            }
            
            if (newPassword.length < 6) {
                showAlert('Şifre en az 6 karakter olmalıdır!', 'info');
                return;
            }
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=change_password&new_password=${encodeURIComponent(newPassword)}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Şifre başarıyla değiştirildi!');
                    document.getElementById('new-password').value = '';
                } else {
                    showAlert(data.error || 'Hata oluştu!', 'info');
                }
            });
        }
        
        function openTestMessageModal() {
            const modal = document.getElementById('testMessageModal');
            modal.style.display = 'block';
        }
        
        function closeTestMessageModal() {
            const modal = document.getElementById('testMessageModal');
            modal.style.display = 'none';
        }
        
        function sendTestMessage() {
            const channelId = document.getElementById('test-channel-select').value;
            if (!channelId) {
                showAlert('Lütfen bir kanal/grup seçin!', 'info');
                return;
            }
            
            // Butonu devre dışı bırak
            const btn = document.querySelector('#testMessageModal .btn-success');
            btn.disabled = true;
            btn.textContent = 'Gönderiliyor...';
            
            fetch('admin.php', {
                method: 'POST',
                headers: { 'Content-Type': 'application/x-www-form-urlencoded' },
                body: `action=send_test_message&channel_id=${channelId}`
            })
            .then(r => r.json())
            .then(data => {
                if (data.success) {
                    showAlert('Test mesajı başarıyla gönderildi!');
                    closeTestMessageModal();
                } else {
                    showAlert(data.error || 'Mesaj gönderilemedi!', 'info');
                }
            })
            .catch(error => {
                showAlert('Bir hata oluştu: ' + error.message, 'info');
            })
            .finally(() => {
                btn.disabled = false;
                btn.textContent = 'Test Mesajı Gönder';
            });
        }
        
        // Modal dışına tıklanınca kapat
        window.onclick = function(event) {
            const modal = document.getElementById('testMessageModal');
            if (event.target == modal) {
                closeTestMessageModal();
            }
        }
    </script>
</body>
</html>

